<!--
Product: Metronic (Tailwind)
Version: v9.2.4
-->
<!DOCTYPE html>
<html class="h-full" data-kt-theme="true" data-kt-theme-mode="light" dir="ltr" lang="en">
 <head><base href="../../">
  <title>Nova Chain Investments</title>
  <meta charset="utf-8"/>
  <meta name="robots" content="follow, index"/>
  <link rel="canonical" href="https://127.0.0.1:8001/metronic-tailwind-html/demo1/index.html"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
  <meta name="description" content=""/>
  <meta name="twitter:site" content="@keenthemes"/>
  <meta name="twitter:creator" content="@keenthemes"/>
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="Metronic - Tailwind CSS "/>
  <meta name="twitter:description" content=""/>
  <meta name="twitter:image" content="assets/media/app/og-image.png"/>
  <meta property="og:url" content="https://127.0.0.1:8001/metronic-tailwind-html/demo1/index.html"/>
  <meta property="og:locale" content="en_US"/>
  <meta property="og:type" content="website"/>
  <meta property="og:site_name" content="@keenthemes"/>
  <meta property="og:title" content="Metronic - Tailwind CSS "/>
  <meta property="og:description" content=""/>
  <meta property="og:image" content="assets/media/app/og-image.png"/>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/media/app/apple-touch-icon.png"/>
  <link rel="icon" type="image/png" sizes="32x32" href="assets/media/app/favicon-32x32.png"/>
  <link rel="icon" type="image/png" sizes="16x16" href="assets/media/app/favicon-16x16.png"/>
  <link rel="shortcut icon" href="assets/media/app/favicon.ico"/>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet"/>
  <link href="assets/vendors/apexcharts/apexcharts.css" rel="stylesheet"/>
  <link href="assets/vendors/keenicons/styles.bundle.css" rel="stylesheet"/>
  <link href="assets/css/styles.css" rel="stylesheet"/>
 </head>
 <body class="antialiased flex h-full text-base text-foreground bg-background demo1 kt-sidebar-fixed kt-header-fixed">
  <!-- Theme Mode -->
  <script>
   const defaultThemeMode = 'light';
   let themeMode;
   if (document.documentElement) {
     if (localStorage.getItem('kt-theme')) {
       themeMode = localStorage.getItem('kt-theme');
     } else if (document.documentElement.hasAttribute('data-kt-theme-mode')) {
       themeMode = document.documentElement.getAttribute('data-kt-theme-mode');
     } else {
       themeMode = defaultThemeMode;
     }
     if (themeMode === 'system') {
       themeMode = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
     }
     document.documentElement.classList.add(themeMode);
   }
  </script>
  <!-- End of Theme Mode -->

  <!-- Page -->
  <div class="flex grow">
   <!-- Sidebar -->
   <div class="kt-sidebar bg-background border-e border-e-border fixed top-0 bottom-0 z-20 hidden lg:flex flex-col items-stretch shrink-0 [--kt-drawer-enable:true] lg:[--kt-drawer-enable:false]" data-kt-drawer="true" data-kt-drawer-class="kt-drawer kt-drawer-start top-0 bottom-0" id="sidebar">
    <div class="kt-sidebar-header hidden lg:flex items-center relative justify-between px-3 lg:px-6 shrink-0" id="sidebar_header">
     <a class="dark:hidden" href="html/demo1/index.php">
      <img class="default-logo min-h-[22px] max-w-none" src="assets/media/app/default-logo.png"/>
      <img class="small-logo min-h-[22px] max-w-none" src="assets/media/app/mini-logo.png"/>
     </a>
     <a class="hidden dark:block" href="html/demo1.html">
      <img class="default-logo min-h-[22px] max-w-none" src="assets/media/app/default-logo-dark.svg"/>
      <img class="small-logo min-h-[22px] max-w-none" src="assets/media/app/mini-logo.svg"/>
     </a>
     <button class="kt-btn kt-btn-outline kt-btn-icon size-[30px] absolute start-full top-2/4 -translate-x-2/4 -translate-y-2/4 rtl:translate-x-2/4" data-kt-toggle="body" data-kt-toggle-class="kt-sidebar-collapse" id="sidebar_toggle">
      <i class="ki-filled ki-black-left-line kt-toggle-active:rotate-180 transition-all duration-300 rtl:translate rtl:rotate-180 rtl:kt-toggle-active:rotate-0"></i>
     </button>
    </div>
    <div class="kt-sidebar-content flex grow shrink-0 py-5 pe-2" id="sidebar_content">
     <div class="kt-scrollable-y-hover grow shrink-0 flex ps-2 lg:ps-5 pe-1 lg:pe-3" data-kt-scrollable="true" data-kt-scrollable-dependencies="#sidebar_header" data-kt-scrollable-height="auto" data-kt-scrollable-offset="0px" data-kt-scrollable-wrappers="#sidebar_content" id="sidebar_scrollable">
      <!-- Sidebar Menu -->
      <div class="kt-menu flex flex-col grow gap-1" data-kt-menu="true" data-kt-menu-accordion-expand-all="false" id="sidebar_menu">
       <div class="kt-menu-item" data-kt-menu-item-toggle="accordion" data-kt-menu-item-trigger="click">
        <div class="kt-menu-link flex items-center grow cursor-pointer border border-transparent gap-[10px] ps-[10px] pe-[10px] py-[6px]" tabindex="0">
         <span class="kt-menu-icon items-start text-muted-foreground w-[20px]">
          <i class="ki-filled ki-element-11 text-lg"></i>
         </span>
         <span class="kt-menu-title text-sm font-medium text-foreground kt-menu-item-active:text-primary kt-menu-link-hover:!text-primary">
          Dashboard
         </span>
         <span class="kt-menu-arrow text-muted-foreground w-[20px] shrink-0 justify-end ms-1 me-[-10px]">
          <span class="inline-flex kt-menu-item-show:hidden"><i class="ki-filled ki-plus text-[11px]"></i></span>
          <span class="hidden kt-menu-item-show:inline-flex"><i class="ki-filled ki-minus text-[11px]"></i></span>
         </span>
        </div>
        <div class="kt-menu-accordion gap-1 ps-[10px] relative before:absolute before:start-[20px] before:top-0 before:bottom-0 before:border-s before:border-border">
            
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="#profile" data-page="profile" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Profile</span>
                </a>
            </div>
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="#kyc" data-page="kyc" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">KYC</span>
                </a>
            </div>
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="#assets" data-page="assets" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Assets</span>
                </a>
            </div>
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="#cservices" data-page="cservices" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Client services</span>
                </a>
            </div>
            
        </div>
       </div>

       <div class="kt-menu-item" data-kt-menu-item-toggle="accordion" data-kt-menu-item-trigger="click">
        <div class="kt-menu-link flex items-center grow cursor-pointer border border-transparent gap-[10px] ps-[10px] pe-[10px] py-[6px]" tabindex="0">
         <span class="kt-menu-icon items-start text-muted-foreground w-[20px]">
          <i class="ki-filled ki-setting-2 text-lg"></i>
         </span>
         <span class="kt-menu-title text-sm font-medium text-foreground kt-menu-item-active:text-primary kt-menu-link-hover:!text-primary">
          Nova CRM
         </span>
         <span class="kt-menu-arrow text-muted-foreground w-[20px] shrink-0 justify-end ms-1 me-[-10px]">
          <span class="inline-flex kt-menu-item-show:hidden"><i class="ki-filled ki-plus text-[11px]"></i></span>
          <span class="hidden kt-menu-item-show:inline-flex"><i class="ki-filled ki-minus text-[11px]"></i></span>
         </span>
        </div>

        
        <div class="kt-menu-accordion gap-1 ps-[10px] relative before:absolute before:start-[20px] before:top-0 before:bottom-0 before:border-s before:border-border">

            <!-- User management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">User management</span>
                </a>
            </div>

            <!-- Client management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] -start-[3px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Client management</span>
                </a>
            </div>

            <!-- Affiliate management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Affiliate management</span>
                </a>
            </div>

            <!-- KYC management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">KYC management</span>
                </a>
            </div>

            <!-- Call management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Call management</span>
                </a>
            </div>

            <!-- Task management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Task management</span>
                </a>
            </div>

            <!-- Client services -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Client services</span>
                </a>
            </div>

            <!-- Assets management -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Assets management</span>
                </a>
            </div>

            <!-- Notifications -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">Notifications</span>
                </a>
            </div>

            <!-- System settings -->
            <div class="kt-menu-item">
                <a class="kt-menu-link border border-transparent items-center grow kt-menu-item-active:bg-accent/60 dark:menu-item-active:border-border kt-menu-item-active:rounded-lg hover:bg-accent/60 hover:rounded-lg gap-[14px] ps-[10px] pe-[10px] py-[8px]" href="javascript:void(0)" tabindex="0">
                    <span class="kt-menu-bullet flex w-[6px] rtl:start-0 relative before:absolute before:top-0 before:size-[6px] before:rounded-full rtl:before:translate-x-1/2 before:-translate-y-1/2 kt-menu-item-active:before:bg-primary kt-menu-item-hover:before:bg-primary"></span>
                    <span class="kt-menu-title text-2sm font-normal text-foreground kt-menu-item-active:text-primary kt-menu-item-active:font-semibold kt-menu-link-hover:!text-primary">System settings</span>
                </a>
            </div>

        </div>
        
       </div>
      </div>
      <!-- End of Sidebar Menu -->
     </div>
    </div>
   </div>
   <!-- End of Sidebar -->

   <!-- Wrapper -->
   <div class="kt-wrapper flex grow flex-col">
    <!-- Header -->
    <header class="kt-header fixed top-0 z-10 start-0 end-0 flex items-stretch shrink-0 bg-background" data-kt-sticky="true" data-kt-sticky-class="border-b border-border" data-kt-sticky-name="header" id="header">
     <div class="kt-container-fixed flex justify-between items-stretch lg:gap-4" id="headerContainer">
      <!-- Left: Mobile Logo -->
      <div class="flex gap-2.5 lg:hidden items-center -ms-1">
       <a class="shrink-0" href="html/demo1.html">
        <img class="max-h-[25px] w/full" src="assets/media/app/mini-logo.svg"/>
       </a>
       <div class="flex items-center">
        <button class="kt-btn kt-btn-icon kt-btn-ghost" data-kt-drawer-toggle="#sidebar"><i class="ki-filled ki-menu"></i></button>
        <button class="kt-btn kt-btn-icon kt-btn-ghost" data-kt-drawer-toggle="#mega_menu_wrapper"><i class="ki-filled ki-burger-menu-2"></i></button>
       </div>
      </div>

      <!-- Center: Megamenu -->
      <div class="flex items-stretch" id="megaMenuContainer">
       <div class="flex items-stretch [--kt-reparent-mode:prepend] [--kt-reparent-target:body] lg:[--kt-reparent-target:#megaMenuContainer] lg:[--kt-reparent-mode:prepend]" data-kt-reparent="true">
        <div class="hidden lg:flex lg:items-stretch [--kt-drawer-enable:true] lg:[--kt-drawer-enable:false]" data-kt-drawer="true" data-kt-drawer-class="kt-drawer kt-drawer-start fixed z-10 top-0 bottom-0 w/full me-5 max-w/[250px] p/[5px] lg:p-0 overflow-auto" id="mega_menu_wrapper">
         <div class="kt-menu flex-col lg:flex-row gap/[5px] lg:gap-7.5" data-kt-menu="true" id="mega_menu">
          <!-- Home -->
          <div class="kt-menu-item active">
           <a class="kt-menu-link text-nowrap text-sm text-foreground font-medium kt-menu-item-hover:text-primary kt-menu-item-active:text-mono kt-menu-item-active:font-medium" href="html/demo1/index.php">
            <span class="kt-menu-title text-nowrap">Home</span>
           </a>
          </div>

          <!-- About us -->
          <div class="kt-menu-item">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="#about" data-page="about">
               <span class="kt-menu-title text-nowrap">About us</span>
            </a>
          </div>

          <!-- Services -->
          <div class="kt-menu-item">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="#services" data-page="services">
               <span class="kt-menu-title text-nowrap">Services</span>
            </a>
          </div>

          <!-- Contact us -->
          <div class="kt-menu-item">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="#contact" data-page="contact">
               <span class="kt-menu-title text-nowrap">Contact us</span>
            </a>
          </div>

          <!-- Register -->
          <div class="kt-menu-item" id="menuRegister">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="#register" data-page="register">
               <span class="kt-menu-title text-nowrap">Register</span>
            </a>
          </div>

          <!-- Login -->
          <div class="kt-menu-item" id="menuLogin">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="#login" data-page="login">
               <span class="kt-menu-title text-nowrap">Login</span>
            </a>
          </div>

          <!-- Logout -->
          <div class="kt-menu-item hidden" id="menuLogout">
            <a class="kt-menu-link text-sm text-secondary-foreground font-medium kt-menu-link-hover:text-primary"
               href="/novademo/html/demo1/authentication/classic/logout.php" id="logoutLink">
               <span class="kt-menu-title text-nowrap">Logout</span>
            </a>
          </div>

         </div>
        </div>
       </div>
      </div>

      <!-- Auth area (Welcome text) -->
      <div class="flex items-center gap-3 pr-3">
        <span id="welcomeUser" class="text-sm text-secondary-foreground hidden"></span>
      </div>

      <div>
      <li data-kt-dropdown="true" data-kt-dropdown-placement="right-start" data-kt-dropdown-trigger="hover">
           <button class="kt-dropdown-menu-toggle py-1" data-kt-dropdown-toggle="true">
            
            <span class="ms-auto kt-badge kt-badge-stroke shrink-0">
             English
             <img alt="" class="inline-block size-3.5 rounded-full" src="assets/media/flags/united-states.svg"/>
            </span>
           </button>
           <div class="kt-dropdown-menu w-[180px]" data-kt-dropdown-menu="true">
            <ul class="kt-dropdown-menu-sub">
             <li class="active">
              <a class="kt-dropdown-menu-link" href="/novademo/html/demo1/index.php#en">
               <span class="flex items-center gap-2">
                <img alt="" class="inline-block size-4 rounded-full" src="assets/media/flags/united-states.svg"/>
                <span class="kt-menu-title">
                 English
                </span>
               </span>
               <i class="ki-solid ki-check-circle ms-auto text-green-500 text-base">
               </i>
              </a>
             </li>
             <li class="">
              <a class="kt-dropdown-menu-link" href="/novademo/html/demo1/index.php#de">
               <span class="flex items-center gap-2">
                <img alt="" class="inline-block size-4 rounded-full" src="assets/media/flags/germany.svg"/>
                <span class="kt-menu-title">
                 German
                </span>
               </span>
              </a>
             </li>
             <li class="">
              <a class="kt-dropdown-menu-link" href="/novademo/html/demo1/index.php#es">
               <span class="flex items-center gap-2">
                <img alt="" class="inline-block size-4 rounded-full" src="assets/media/flags/spain.svg"/>
                <span class="kt-menu-title">
                 Spanish
                </span>
               </span>
              </a>
             </li>
             
            </ul>
           </div>
       </li>
      </div>
     </div>


    </header>
    <!-- End of Header -->

    <!-- Content -->
    <main class="grow pt-5" id="content" role="content">
     <div class="kt-container-fixed" id="contentContainer">
       <div id="contentPlaceholder" class="text-secondary-foreground text-sm p-6">
         Welcome to <strong>Nova Chain Investments</strong>. Use the menu to view more.
       </div>
     </div>
     <div class="kt-container-fixed"></div>
    </main>
    <!-- End of Content -->

    <!-- Footer -->
    <footer class="kt-footer">
     <div class="kt-container-fixed">
      <div class="flex flex-col md:flex-row justify-center md:justify-between items-center gap-3 py-5">
       <div class="flex order-2 md:order-1 gap-2 font-normal text-sm">
        <span class="text-secondary-foreground">2025©</span>
        <a class="text-secondary-foreground hover:text-primary" href="html/demo1/index.php">Nova Chain Investment.</a>
       </div>
      </div>
     </div>
    </footer>
   </div>
   <!-- End of Wrapper -->
  </div>
  <!-- End of Main -->

  <!-- Scripts -->
  <script src="assets/js/core.bundle.js"></script>
  <script src="assets/vendors/ktui/ktui.min.js"></script>
  <script src="assets/vendors/apexcharts/apexcharts.min.js"></script>
  <script src="assets/js/widgets/general.js"></script>
  <script src="assets/js/layouts/demo1.js"></script>

  <!-- SPA-style loader -->
<script>
(function () {
  const container   = document.getElementById('contentContainer');
  const welcomeEl   = document.getElementById('welcomeUser');
  const menuLogin   = document.getElementById('menuLogin');
  const menuLogout  = document.getElementById('menuLogout');
  const BASE_DIR    = '/novademo/html/demo1/';

  const PAGE_CANDIDATES = {
    about:    [BASE_DIR + 'about.php',    BASE_DIR + 'about.html'],
    services: [BASE_DIR + 'services.php', BASE_DIR + 'services.html'],
    contact:  [BASE_DIR + 'contact.php',  BASE_DIR + 'contact.html'],
    login:    [BASE_DIR + 'authentication/classic/sign-in.php',  BASE_DIR + 'authentication/classic/sign-in.html'],
    register: [BASE_DIR + 'authentication/classic/sign-up.php',  BASE_DIR + 'authentication/classic/sign-up.html'],
    signup:   [BASE_DIR + 'authentication/classic/sign-up.php',  BASE_DIR + 'authentication/classic/sign-up.html'],
    forgot:   [BASE_DIR + 'authentication/classic/reset-password/enter-email.php',
               BASE_DIR + 'authentication/classic/reset-password/enter-email.html'],
    login_error: [BASE_DIR + 'authentication/classic/partials/login_error.php'],

   
    profile:  [BASE_DIR + 'userdashboard/profile.php'],
    kyc:      [BASE_DIR + 'userdashboard/kyc.php'],
    assets:   [BASE_DIR + 'userdashboard/assets.php'],
    cservices:[BASE_DIR + 'userdashboard/cservices.php'],

    
    'change-password': [
      BASE_DIR + 'authentication/classis/reset-password/change-password.php',
      BASE_DIR + 'authentication/classis/reset-password/change-password.html',
      BASE_DIR + 'authentication/classic/reset-password/change-password.php',
      BASE_DIR + 'authentication/classic/reset-password/change-password.html'
    ]
  };

  function hrefToKey(href) {
    try {
      const u = new URL(href, window.location.origin);
      const p = u.pathname.toLowerCase();
      if (p.endsWith('/authentication/classic/sign-in.php') || p.endsWith('/authentication/classic/sign-in.html')) return 'login';
      if (p.endsWith('/authentication/classic/sign-up.php') || p.endsWith('/authentication/classic/sign-up.html')) return 'signup';
      if (p.endsWith('/authentication/classic/reset-password/enter-email.php') || p.endsWith('/authentication/classic/reset-password/enter-email.html')) return 'forgot';
      if (p.endsWith('/authentication/classic/partials/login_error.php')) return 'login_error';
      if (p.endsWith('/about.php') || p.endsWith('/about.html')) return 'about';
      if (p.endsWith('/services.php') || p.endsWith('/services.html')) return 'services';
      if (p.endsWith('/contact.php') || p.endsWith('/contact.html')) return 'contact';
    } catch (e) {}
    return null;
  }

  function parseHash() {
    const raw = (location.hash || '#').slice(1);
    if (!raw) return { key: '', params: {} };
    const [key, q = ''] = raw.split('?');
    const params = {};
    if (q) {
      for (const part of q.split('&')) {
        const [k, v = ''] = part.split('=');
        params[decodeURIComponent(k)] = decodeURIComponent(v);
      }
    }
    return { key, params };
  }

  async function fetchFirstOk(urls, options) {
    for (const url of urls) {
      try {
        const res = await fetch(url, {
          headers: { 'X-Requested-With': 'fetch', ...(options?.headers||{}) },
          credentials: 'same-origin',
          cache: 'no-store',
          method: options?.method || 'GET',
          body: options?.body
        });
        if (res.ok) return { res, url };
        console.warn('Fetch failed', url, res.status, res.statusText);
      } catch (e) {
        console.warn('Fetch error', url, e);
      }
    }
    throw new Error('All candidates failed:\n' + urls.join('\n'));
  }

  function extractContent(htmlText) {
    const parser = new DOMParser();
    const doc = parser.parseFromString(htmlText, 'text/html');
    const pick =
      doc.querySelector('#page-content') ||
      doc.querySelector('[data-embed-root]') ||
      doc.querySelector('main') ||
      doc.body;
    if (pick && pick !== doc.body) return pick.outerHTML;
    return pick ? pick.innerHTML : htmlText;
  }

  async function loadPage(key, params = {}, replaceState = false) {
    const urls = PAGE_CANDIDATES[key];
    if (!urls) return;

    const attachQuery = (u) => {
      if (key === 'login_error' && params.m) {
        const sep = u.includes('?') ? '&' : '?';
        return u + sep + 'm=' + encodeURIComponent(params.m);
      }
      return u;
    };

    container.innerHTML = `<div class="p-6 text-sm text-secondary-foreground">Loading ${key}...</div>`;
    try {
      const withQuery = urls.map(attachQuery);
      const { res, url } = await fetchFirstOk(withQuery);
      const html = await res.text();
      container.innerHTML = extractContent(html);

      const pairs = Object.entries(params).map(([k,v]) => `${encodeURIComponent(k)}=${encodeURIComponent(v)}`).join('&');
      const newHash = pairs ? `${key}?${pairs}` : key;

      const newUrl = new URL(window.location);
      newUrl.hash = newHash;
      (replaceState ? history.replaceState : history.pushState).call(history, { page: key, params }, '', newUrl);

      setActive(key);
      console.info('Loaded', key, 'from', url);

      
      wireSpaFormSubmit();
    } catch (err) {
      console.error(err);
      container.innerHTML = `<div class="p-6 text-sm text-destructive-foreground">Failed to load ${key}. Check console for details.</div>`;
    }
  }

  function setActive(key) {
    document.querySelectorAll('[data-page]').forEach(a => {
      const active = a.dataset.page === key;
      a.classList.toggle('kt-menu-item-active', active);
      a.classList.toggle('text-primary', active);
    });
  }

  // ---- Auth UI: show/hide ----
  async function refreshAuthUI() {
    try {
      const res = await fetch('/novademo/html/demo1/auth_status.php', {
        credentials: 'same-origin',
        cache: 'no-store',
        headers: { 'Accept': 'application/json' }
      });
      if (!res.ok) throw new Error('auth_status failed ' + res.status);
      const data = await res.json(); // {is_authenticated, user_email}

      if (data.is_authenticated) {
        menuLogin?.classList.add('hidden');
        menuLogout?.classList.remove('hidden');
        if (welcomeEl) {
          const email = (data.user_email || '').toString();
          welcomeEl.textContent = `Welcome, ${email}`;
          welcomeEl.classList.remove('hidden');
        }
      } else {
        menuLogout?.classList.add('hidden');
        menuLogin?.classList.remove('hidden');
        if (welcomeEl) {
          welcomeEl.textContent = '';
          welcomeEl.classList.add('hidden');
        }
      }
    } catch (e) {
      console.warn('Auth UI refresh failed', e);
      // fail closed: show login, hide logout
      menuLogout?.classList.add('hidden');
      menuLogin?.classList.remove('hidden');
      welcomeEl?.classList.add('hidden');
    }
  }

  // ---- SPA link interception ----
  document.addEventListener('click', (e) => {
    const link = e.target.closest('a[href]');
    if (!link) return;

    // Don't intercept real logout (server must run)
    if (link.id === 'logoutLink') return;

    const keyByData = link.dataset.page;
    if (keyByData && PAGE_CANDIDATES[keyByData]) {
      e.preventDefault();
      loadPage(keyByData);
      return;
    }

    const keyByHref = hrefToKey(link.getAttribute('href'));
    if (keyByHref && PAGE_CANDIDATES[keyByHref]) {
      e.preventDefault();
      loadPage(keyByHref);
    }
  });

  // ---- SPA form interception for /send_contact.php ----
  function isSendContactAction(action) {
    try {
      const u = new URL(action, window.location.origin);
      return u.pathname.endsWith('/send_contact.php') || u.pathname.endsWith('send_contact.php');
    } catch (e) {
      // relative or invalid? fallback string check
      return (action || '').toLowerCase().endsWith('send_contact.php');
    }
  }

  async function postContactViaSpa(form) {
    const action = form.getAttribute('action') || (BASE_DIR + 'send_contact.php');
    const fd = new FormData(form);

    // UI: sending state
    container.innerHTML = `<div class="p-6 text-sm text-secondary-foreground">Sending message…</div>`;

    try {
      const res = await fetch(action, {
        method: 'POST',
        body: fd,
        credentials: 'same-origin',
        headers: { 'X-Requested-With': 'fetch' },
        cache: 'no-store'
      });

      const text = await res.text();
      container.innerHTML = extractContent(text);

      // Update hash so back/forward won't trigger a "resubmit form"
      const newUrl = new URL(window.location);
      const statusParam = res.ok ? 'sent' : 'error';
      newUrl.hash = 'contact?status=' + statusParam;
      history.pushState({ page: 'contact', params: { status: statusParam } }, '', newUrl);

      setActive('contact');
      // After injection, wire any SPA forms/links in the returned markup
      wireSpaFormSubmit();
    } catch (err) {
      console.error('Contact post failed', err);
      container.innerHTML = `<div class="p-6 text-sm text-destructive-foreground">Could not send your message. Please try again later.</div>`;
      const newUrl = new URL(window.location);
      newUrl.hash = 'contact?status=error';
      history.pushState({ page: 'contact', params: { status: 'error' } }, '', newUrl);
      setActive('contact');
    }
  }

  function wireSpaFormSubmit() {
    // Delegate on the content container only (re-wires after each load)
    container.querySelectorAll('form').forEach(form => {
      if (form.__novaSpaWired) return; // avoid double-binding
      form.__novaSpaWired = true;

      form.addEventListener('submit', (ev) => {
        const action = form.getAttribute('action') || '';
        if (isSendContactAction(action)) {
          ev.preventDefault();
          postContactViaSpa(form);
        }
      });
    });
  }

  // Back/forward
  window.addEventListener('popstate', () => {
    const { key, params } = parseHash();
    if (PAGE_CANDIDATES[key]) loadPage(key, params, true);
  });

  // Initial load
  document.addEventListener('DOMContentLoaded', async () => {
    await refreshAuthUI();
    const { key, params } = parseHash();
    if (PAGE_CANDIDATES[key]) {
      loadPage(key, params, true);
    }
    // In case the initial HTML already contains a contact form
    wireSpaFormSubmit();
  });

  // After every AJAX load, refresh auth UI (e.g., after error page or navigating)
  document.addEventListener('readystatechange', () => {
    if (document.readyState === 'complete') {
      refreshAuthUI();
    }
  });

})();
</script>
  <!-- End SPA loader -->
 </body>
</html>
